(function ($) {
    "use strict"; // Start of use strict

    // Toggle the side navigation
    $("#sidebarToggle, #sidebarToggleTop").on("click", function (e) {
        $("body").toggleClass("sidebar-toggled");
        $(".sidebar").toggleClass("toggled");
        if ($(".sidebar").hasClass("toggled")) {
            $(".sidebar .collapse").collapse("hide");
        }
    });

    // Resize handler: Sesuaikan perilaku sidebar di mobile
    $(window).resize(function () {
        if ($(window).width() < 768) {
            // Jangan tutup collapse otomatis saat resize di mobile
            // $(".sidebar .collapse").collapse("hide"); // Dikomplain agar tidak langsung collapse
        }

        // Hapus auto-toggle di <480px agar sidebar tetap terkontrol manual
        // if ($(window).width() < 480 && !$(".sidebar").hasClass("toggled")) {
        //     $("body").addClass("sidebar-toggled");
        //     $(".sidebar").addClass("toggled");
        //     $(".sidebar .collapse").collapse("hide");
        // }
    });

    // Tambahkan handler untuk mencegah sidebar tertutup saat scroll di mobile
    if ($(window).width() < 768) {
        $(document).on("scroll", function () {
            // Pastikan sidebar tidak ditutup otomatis saat scroll
            if ($(".sidebar").hasClass("toggled")) {
                $(".sidebar").removeClass("toggled");
                $("body").removeClass("sidebar-toggled");
            }
        });
    }

    // Prevent the content wrapper from scrolling when the fixed side navigation hovered over
    $("body.fixed-nav .sidebar").on(
        "mousewheel DOMMouseScroll wheel",
        function (e) {
            if ($(window).width() > 768) {
                var e0 = e.originalEvent,
                    delta = e0.wheelDelta || -e0.detail;
                this.scrollTop += (delta < 0 ? 1 : -1) * 30;
                e.preventDefault();
            }
        }
    );

    // Scroll to top button appear
    $(document).on("scroll", function () {
        var scrollDistance = $(this).scrollTop();
        if (scrollDistance > 100) {
            $(".scroll-to-top").fadeIn();
        } else {
            $(".scroll-to-top").fadeOut();
        }
    });

    // Smooth scrolling using jQuery easing
    $(document).on("click", "a.scroll-to-top", function (e) {
        var $anchor = $(this);
        $("html, body")
            .stop()
            .animate(
                {
                    scrollTop: $($anchor.attr("href")).offset().top,
                },
                1000,
                "easeInOutExpo"
            );
        e.preventDefault();
    });

    // Tambah baris input data
    $("#tambah-baris").click(function () {
        var no = $("#tabel-input-body tr").length + 1;
        var html =
            "<tr>" +
            "<td>" +
            no +
            "</td>" +
            '<td><input type="text" name="nama_barang[]" class="form-control"></td>' +
            '<td><input type="number" name="jumlah[]" class="form-control"></td>' +
            '<td><input type="number" name="harga[]" class="form-control"></td>' +
            '<td><input type="number" name="total[]" class="form-control" readonly></td>' +
            "</tr>";
        $("#tabel-input-body").append(html);
    });

    // Simpan data
    $("#simpan-data").click(function () {
        var tanggal = $("#tanggal").val();
        var jenis_muatan = $("#jenis_muatan").val();
        var data = [];
        $("#tabel-input-body tr").each(function () {
            var nama_barang = $(this).find('input[name="nama_barang[]"]').val();
            var jumlah = $(this).find('input[name="jumlah[]"]').val();
            var harga = $(this).find('input[name="harga[]"]').val();
            var total = $(this).find('input[name="total[]"]').val();
            data.push({
                tanggal: tanggal,
                jenis_muatan: jenis_muatan,
                nama_barang: nama_barang,
                jumlah: jumlah,
                harga: harga,
                total: total,
            });
        });
        $.ajax({
            type: "POST",
            url: "<?= base_url('penjualan/simpan_data'); ?>",
            data: { data: data },
            success: function () {
                alert("Data berhasil disimpan!");
            },
            error: function (xhr, status, error) {
                alert("Terjadi kesalahan: " + error);
            },
        });
    });

    // Update label file input
    $(".custom-file-input").on("change", function () {
        let fileName = $(this).val().split("\\").pop();
        $(this).next(".custom-file-label").html(fileName);
    });

})(jQuery); // End of use strict